import logging
import unittest
from datetime import datetime as dt

from py_jftech import autowired, to_str, parse_date, prev_workday

from api import RoboReportor, RoboExportor

logger = logging.getLogger(__name__)


class ReportTest(unittest.TestCase):

    @autowired(names={'reportor': 'benckmark-report'})
    def test_benchmark_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'indicators-report'})
    def test_indicator_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'fixed-range-report'})
    def test_fixed_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'relative-range-report'})
    def test_relative_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'contribution-report'})
    def test_contribution_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-21'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'combo-report'})
    def test_combo_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'year-range-report'})
    def test_year_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'month-div-rate-report'})
    def test_year_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'reportor': 'year-div-rate-report'})
    def test_year_report(self, reportor: RoboReportor = None):
        result = reportor.load_report(max_date=parse_date('2023-03-01'))
        logger.info(to_str(result))

    @autowired(names={'exportor': 'backtest-export'})
    def test_backtest_export(self, exportor: RoboExportor = None):
        exportor.export(max_date=parse_date('2023-03-01'))

    @autowired(names={'exportor': 'daily-real-export'})
    def test_daily_export(self, exportor: RoboExportor = None):
        exportor.export(max_date=prev_workday(dt.today()))

    @autowired(names={'exportor': 'daily-monitor-export'})
    def test_daily_monitor(self, exportor: RoboExportor = None):
        exportor.export(max_date=parse_date('2023-03-27'))


if __name__ == '__main__':
    unittest.main()
