CREATE TABLE IF NOT EXISTS robo_rebalance_signal
(
    rrs_id          BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    rrs_date        DATETIME        NOT NULL COMMENT '信号日期',
    rrs_type        TINYINT         NOT NULL COMMENT '信号类型',
    rrs_risk        TINYINT         NOT NULL COMMENT '风险等级',
    rrs_p_type      VARCHAR(255)             DEFAULT NULL COMMENT '投组类型',
    rrs_p_weight    JSON                     DEFAULT NULL COMMENT '投组信息',
    rrs_effective   TINYINT         NOT NULL DEFAULT 0 COMMENT '是否生效',
    rrs_create_time DATETIME        NOT NULL DEFAULT CURRENT_TIMESTAMP,
    rrs_update_time DATETIME                 DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (rrs_id),
    INDEX (rrs_date),
    INDEX (rrs_type),
    INDEX (rrs_risk)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT '再平衡信号表';


