import logging
import unittest

from py_jftech import autowired, parse_date

from api import PortfoliosBuilder, PortfoliosType, PortfoliosRisk, PortfoliosHolder


class PortfoliosTest(unittest.TestCase):
    logger = logging.getLogger(__name__)

    @autowired(names={'builder': 'poem'})
    def test_poem_build_portfolio(self, builder: PortfoliosBuilder = None):
        result, detail = builder.build_portfolio(parse_date('2008-01-21'), PortfoliosType.NORMAL)
        self.logger.info("portfolios: ")
        for risk, portfolio in result.items():
            self.logger.info(risk.name)
            self.logger.info(portfolio)
            self.logger.info(detail[risk])

    @autowired(names={'builder': 'poem'})
    def test_poem_get_portfolio(self, builder: PortfoliosBuilder = None):
        portfolio = builder.get_portfolios(parse_date('2022-11-07'), PortfoliosRisk.FT9)
        self.logger.info(portfolio)

    @autowired(names={'hold': 'dividend-holder'})
    def test_has_hold(self, hold: PortfoliosHolder = None):
        self.logger.info(hold.has_hold(PortfoliosRisk.FT3))

    @autowired(names={'hold': 'dividend-holder'})
    def test_build_hold(self, hold: PortfoliosHolder = None):
        hold.build_hold_portfolio(parse_date('2023-02-23'), PortfoliosRisk.FT9)

    @autowired(names={'hold': 'dividend-holder'})
    def test_clear(self, hold: PortfoliosHolder = None):
        hold.clear()


if __name__ == '__main__':
    unittest.main()
