import os
import re

import subprocess
import sys
from datetime import datetime


def run_main(pyfile='main.py'):
    """运行指定程序"""
    try:
        # 执行原程序
        print(f"[{datetime.now()}] 开始执行{pyfile}程序...")
        result = subprocess.run(
            [sys.executable, pyfile],  # 请替换为实际的主程序文件名
            capture_output=True,
            text=True,
            check=True
        )
        print(f"[{datetime.now()}] 程序执行完成")
        print("标准输出:", result.stdout)
        if result.stderr:
            print("标准错误:", result.stderr)
        return True
    except subprocess.CalledProcessError as e:
        print(f"[{datetime.now()}] {pyfile}程序执行失败: {e}")
        print("错误输出:", e.stderr)
        return False
    except Exception as e:
        print(f"[{datetime.now()}] {pyfile}执行过程中发生未知错误: {e}")
        return False

def update_env_variable(env_path='.env', key='PROFILE_ACTIVE', new_value='new_value'):
    """
    更新.env文件中的指定环境变量
    参数:
        env_path: .env文件路径
        key: 要更新的环境变量名
        new_value: 新的环境变量值
    """
    # 检查文件是否存在
    if not os.path.exists(env_path):
        print(f"错误: {env_path} 文件不存在")
        return False

    # 读取文件内容
    with open(env_path, 'r', encoding='utf-8') as file:
        content = file.read()

    # 使用正则表达式查找并替换目标变量
    pattern = rf'^{key}\s*=\s*(\w+)$'
    replacement = f'{key}={new_value}'

    # 替换匹配的行
    updated_content = re.sub(pattern, replacement, content, flags=re.MULTILINE)

    # 判断内容是否变化，有则写入更新后的内容
    if content == updated_content:
        print(f"内容没有变化 {env_path} 文件: {key}={new_value}")
    else:
        # 写入更新后的内容
        with open(env_path, 'w', encoding='utf-8') as file:
            file.write(updated_content)

        print(f"已成功更新 {env_path} 文件: {key}={new_value}")
    return True


if __name__ == "__main__":
    # 更新.env
    profile_active = [
        'industryfund',
        'usmarket_prr4',
        'lowrisk_rr3',
        'mdis_prr3',
        'emmarket_prr4',
    ]

    for pa in profile_active:
        update_env_variable(
            env_path='.env',  # .env文件路径
            key='PROFILE_ACTIVE',  # 要更新的变量名
            new_value=pa  # 新的变量值
        )

        # 运行main.py
        run_main(pyfile='main.py')