import logging
import unittest
from typing import List

from py_jftech import autowired, parse_date, to_str

from api import Navs, Datum, PortfoliosRisk, DataSync

logger = logging.getLogger(__name__)


class BasicTest(unittest.TestCase):

    @autowired
    def test_index_close(self, navs: Navs = None):
        closes = navs.get_index_close(ticker='SPX Index', min_date=parse_date('2022-11-01'), datum_ids=67)
        logger.info(closes)

    @autowired
    def test_get_high_risk_datums(self, datum: Datum = None):
        datums = datum.get_high_risk_datums(PortfoliosRisk.FT9)
        logger.info(datums)

    @autowired(names={'sync': 'index-sync'})
    def test_index_sync(self, sync: DataSync = None):
        sync.do_sync()

    @autowired(names={'sync': 'eco-sync'})
    def test_eco_sync(self, sync: DataSync = None):
        sync.do_sync()

    @autowired(names={'sync': 'navs-sync'})
    def test_navs_sync(self, sync: DataSync = None):
        sync.do_sync()

    @autowired(names={'sync': 'exrate-sync'})
    def test_exrate_sync(self, sync: DataSync = None):
        sync.do_sync()

    @autowired
    def test_sync(self, syncs: List[DataSync] = None):
        for sync in syncs:
            sync.do_sync()


if __name__ == '__main__':
    unittest.main()
