from datetime import datetime as dt

from py_jftech import component, autowired

from api import AssetPool, AssetOptimize
from asset_pool.dao import robo_assets_pool as rap, robo_indicator


@component
class FundAssetPool(AssetPool):

    @autowired
    def __init__(self, optimize: AssetOptimize = None):
        self._optimize = optimize

    def get_pool(self, day=dt.today()):
        return self._optimize.get_optimize_pool(day)

    def clear(self, day=None):
        rap.delete(day)
        robo_indicator.clear()
