from py_jftech import write, mapper_columns

__COLUMNS__ = {
    'ri_rbd_id': 'id',
    'ri_date': 'date',
    'ri_annual': 'annual',
    'ri_sortino': 'sortino',
}


@write
def insert(datas):
    datas = [mapper_columns(datas=x, columns=__COLUMNS__, ignore_none=False) for x in datas]
    values = ','.join(
        [f'''({','.join([(f"'{x[j]}'" if j in x and x[j] is not None else 'null') for j in __COLUMNS__.keys()])})''' for
         x in datas])
    return f'''insert ignore into robo_indicator({','.join(__COLUMNS__.keys())}) values {values}'''


@write
def update_sortino(id, date, sortino):
    return f'''update robo_indicator set ri_sortino='{sortino}' where ri_rbd_id={id} and ri_date='{date}' '''


@write
def clear():
    return 'TRUNCATE robo_indicator'
