CREATE TABLE IF NOT EXISTS robo_assets_pool
(
    rap_id          BIGINT UNSIGNED NOT NULL AUTO_INCREMENT,
    rap_date        DATETIME        NOT NULL COMMENT '数据日期',
    rap_type        TINYINT         NOT NULL COMMENT '资产池类别',
    rap_asset_ids   JSON                     DEFAULT NULL COMMENT '基金ID',
    rap_create_time DATETIME        NOT NULL DEFAULT CURRENT_TIMESTAMP,
    rap_update_time DATETIME                 DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (rap_id),
    UNIQUE INDEX (rap_date, rap_type),
    INDEX (rap_type)
) ENGINE = InnoDB
  AUTO_INCREMENT = 0
  DEFAULT CHARSET = utf8mb4 COMMENT '资产池';

CREATE TABLE IF NOT EXISTS robo_indicator
  (
  `ri_rbd_id` bigint(20) NOT NULL,
  `ri_date` datetime NOT NULL,
  `ri_annual` double NOT NULL,
  `ri_sortino` json NULL,
  `ri_create_time` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `ri_update_time` datetime NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  UNIQUE INDEX `ri_rbd_id`(`ri_rbd_id`, `ri_date`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;